import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import secuotp.jradiusclt.exception.*;
import secuotp.jradiusclt.*;

public class Jradiusdemo {
	public static void usage()
	{
		System.out.println("Usage: auth_Server auth_Port share_Secret auth_Username auth_Password");
		//System.exit(1);
	}
	public static void main(String args[])
	{
		if(args.length < 5)
		{
			usage();
			System.exit(2);
		}
		RadiusClient rc = null;
		String sHost = args[0];
		int nPort = 1812;
		try
		{
			nPort = Integer.parseInt(args[1]);
		}
		catch(NumberFormatException e)
		{
			System.out.println("port must be a positive integer!");
			usage();
			System.exit(3);
		}
		String sSecret = args[2];
		String sUsername = args[3];
		String sPassword = args[4];
		try
		{
			//create a RadiusClient Object
			rc = new RadiusClient(sHost, nPort, sSecret, sUsername);
		}
		catch(java.net.SocketException soex)//socket exception
		{
            System.out.println("Unable to create Radius Client due to failure to create socket!");
            usage();
            System.exit(4);
        }
		catch(java.security.NoSuchAlgorithmException nsaex)//Algorithm invalid
		{
            System.out.println("Unable to create Radius Client due to failure to create MD5 MessageDigest!");
            usage();
            System.exit(5);
        }
		catch(InvalidParameterException ivpex)//parameter invalid
		{
            System.out.println("Unable to create Radius Client due to invalid parameter!");
            System.out.println(ivpex.getMessage());
            usage();
            System.exit(6);
        }
		try
		{
			int nRetCode = rc.authenticate(sPassword);
			switch(nRetCode)
			{
			case RadiusValues.ACCESS_ACCEPT:
				System.out.println("Authenticated!!");
				System.exit(0);
			case RadiusValues.ACCESS_REJECT:
				System.out.println("Not authenticated!!");
				System.exit(7);
			case RadiusValues.ACCESS_CHALLENGE:
				System.out.println(rc.getChallengeMessage());
				System.exit(8);
			default:
				System.out.println("Unknown operation!!");
				System.exit(9);
			}
		}
		catch(Exception e)
		{
			System.out.println("authentication exception:"+e.getMessage());
			usage();
			System.exit(7);
		}
	}
}
